
SELECT tsystem.function__drop_by_regex( 'auditlog__table__ident_json', 'tlog', _commit => true );
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab ab2 ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                               concat_ws( ': ', '"a2_ab_ix"', _tab.a2_ab_ix ),
                               concat_ws( ': ', '"a2_n"'    , _tab.a2_n )
                      ) ||  '}' )::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab ab2ba ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                              '"a2_ab_ix": '    || ( SELECT  a2_ab_ix FROM ab2 WHERE a2_id = _tab.a2ba_a2_id ),
                              '"a2_ks": "'      || ( SELECT  a2_ks    FROM ab2 WHERE a2_id = _tab.a2ba_a2_id ) || '"',
                              '"a2_n": '        || ( SELECT  a2_n     FROM ab2 WHERE a2_id = _tab.a2ba_a2_id ),
                              '"a2ba_ak_nr": "' || _tab.a2ba_ak_nr || '"'
                      ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab abk ) RETURNS json AS $$
       SELECT ( '{' || '"ab_ix": ' || _tab.ab_ix ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab adk ) RETURNS json AS $$
   SELECT ( '{' || '"ad_krz": ' || _tab.ad_krz ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab adk_adresses ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                              '"ada_ad_krz": "' || _tab.ada_ad_krz || '"',
                              '"ada_fa1": "'    || _tab.ada_fa1    || '"', 
                              '"ada_str": "'    || _tab.ada_str    || '"', 
                              '"ada_plz": "'    || _tab.ada_plz    || '"', 
                              '"ada_ort": "'    || _tab.ada_ort    || '"' 
                                ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab adk1 ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                              '"a1_krz": "' || _tab.a1_krz || '"',
                              '"a1_knr": "' || _tab.a1_knr || '"'
                      ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab adk2 ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                              '"a1_krz": "' || _tab.a2_krz || '"',
                              '"a1_krz": "' || _tab.a2_knr || '"' 
                      ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab adkap ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                              '"ap_ad_krz": "' || _tab.ap_ad_krz || '"',
                              '"ap_vorn": "'   || _tab.ap_vorn   || '"'
                                ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab anl ) RETURNS json AS $$
        SELECT ( '{' || '"an_nr": ' || _tab.an_nr ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab art ) RETURNS json AS $$
        SELECT ( '{' || concat_ws( ', ', 
                                         '"ak_nr": "' || _tab.ak_nr || '"', 
                                         '"ak_bez": "' || _tab.ak_bez || '"' 
                                 ) ||  '}' 
               ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab artblang ) RETURNS json AS $$
       SELECT ( '{' || '"akbl_ak_nr": ' || _tab.akbl_spr_key ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab artcod ) RETURNS json AS $$
       SELECT ( '{' || '"ac_n": ' || _tab.ac_n ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab artcodlang ) RETURNS json AS $$
             SELECT ( '{' || concat_ws( ', ',
                              '"acl_ac_n": "' || _tab.acl_ac_n || '"',
                              '"acl_spr_key": "' || _tab.acl_spr_key || '"' 
                      ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab artdlang ) RETURNS json AS $$
             SELECT ( '{' || concat_ws( ', ',
                              '"akdl_ak_nr": "' || _tab.akdl_ak_nr || '"',
                              '"akdl_spr_key": "' || _tab.akdl_spr_key || '"' 
                      ) ||  '}' ) ::json;   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab artdokutxt ) RETURNS json AS $$
             SELECT ( '{' || concat_ws( ', ',
                              '"adtx_ak_nr": "' || _tab.adtx_ak_nr || '"',
                              '"adtx_spr_key": "' || _tab.adtx_spr_key || '"' 
                      ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab artinfo ) RETURNS json AS $$
   SELECT ( '{' || '"ain_ak_nr": ' || _tab.ain_ak_nr ||  '}' ) ::json;   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab artmlang ) RETURNS json AS $$
             SELECT ( '{' || concat_ws( ', ',
                              '"akml_ak_nr": "' || _tab.akml_ak_nr || '"',
                              '"akml_spr_key": "' || _tab.akml_spr_key || '"' 
                      ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab artoption_arts ) RETURNS json AS $$
             SELECT ( '{' || concat_ws( ', ',
                              '"aoa_pos": "' || _tab.aoa_pos || '"',
                              '"aoa_g_ak_nr": "' || _tab.aoa_g_ak_nr || '"' 
                      ) ||  '}' ) ::json; 
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab artpr ) RETURNS json AS $$
             SELECT ( '{' || concat_ws( ', ',
                              '"pr_id": "' || _tab.pr_id || '"',
                              '"pr_aknr": "' || _tab.pr_aknr || '"',
                              '"pr_pmnr": "' || _tab.pr_pmnr || '"',
                              '"pr_mebe": "' || _tab.pr_mebe || '"' 
                      ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab artpruefung ) RETURNS json AS $$
             SELECT ( '{' || concat_ws( ', ',
                              '"apr_pos": "' || _tab.apr_pos || '"',
                              '"apr_aknr": "' || _tab.apr_aknr || '"',
                              '"apr_ac": "' || _tab.apr_ac || '"' 
                      ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab artpruefungtest ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                              '"aprt_pos": '  || _tab.aprt_pos,
                              '"apr_aknr": "' || ( SELECT apr_aknr FROM artpruefung WHERE apr_id = _tab.aprt_apr_id ) || '"',
                              '"apr_ac": "'   || ( SELECT apr_ac   FROM artpruefung WHERE apr_id = _tab.aprt_apr_id ) || '"',
                              '"aprt_txt": "' || substring( _tab.aprt_txt, 50 ) || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab artrab ) RETURNS json AS $$
       SELECT ( '{' || '"rab_aknr": "' || _tab.rab_aknr || '"' ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab artstp ) RETURNS json AS $$
       SELECT ( '{' || '"astp_aknr": "' || _tab.astp_aknr || '"' ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab artvkp ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                              '"vkp_aknr": "'  || _tab.vkp_aknr || '"',
                              '"vkp_kukl": "'  || _tab.vkp_kukl || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab artzuo ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                              '"az_pronr": "'  || _tab.az_pronr  || '"',
                              '"az_prokrz": "' || _tab.az_prokrz || '"',
                              '"az_kunr": "'   || _tab.az_kunr   || '"'
              ) ||  '}' ) ::json; 
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab artzust ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                              '"az_aknr": "'          || _tab.az_aknr  || '"',
                              '"az_ll_db_usename": "' || _tab.az_ll_db_usename || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab auftg ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                              '"ag_astat": "' || _tab.ag_astat || '"',
                                '"ag_nr": "'    || _tab.ag_nr    || '"',
                              '"ag_pos": '    || _tab.ag_pos,
                              '"ag_lkn": "'   || _tab.ag_lkn   || '"',
                              '"ag_aknr": "'  || _tab.ag_aknr  || '"'
              ) ||  '}' ) ::json; 
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab auftgabzu ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                              '"az_pos": "'   || _tab.az_pos || '"',
                              '"ag_astat": "' || ( SELECT ag_astat  FROM auftg WHERE ag_id  = _tab.az_ag_id )  || '"',
                              '"ag_nr": "'    || ( SELECT ag_nr     FROM auftg WHERE ag_id  = _tab.az_ag_id )  || '"',
                              '"ag_pos": '    || ( SELECT ag_pos    FROM auftg WHERE ag_id  = _tab.az_ag_id ),
                              '"abz_txt": "'  || ( SELECT abz_txt   FROM abzu  WHERE abz_id = _tab.az_abz_id ) || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab auftgdokutxt ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                              '"atd_titel": "'   || substr( _tab.atd_titel, 1, 50 ) || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab auftgmatinfo ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"agmi_id": "'     || _tab.agmi_id || '"',
                                 '"ag_astat": "' || ( SELECT ag_astat  FROM auftg WHERE ag_id = _tab.agmi_ag_id ) || '"',
                                 '"ag_nr": "'    || ( SELECT ag_nr     FROM auftg WHERE ag_id = _tab.agmi_ag_id ) || '"',
                                 '"ag_pos": '    || ( SELECT ag_pos    FROM auftg WHERE ag_id = _tab.agmi_ag_id )
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab bdeabgruende ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                              '"ab_id": '       || _tab.ab_id,
                              '"ab_grup": "' || _tab.ab_grup || '"',
                              '"ab_id": "'   || substring( _tab.ab_txt from 1 for 20 ) || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab bdep ) RETURNS json AS $$
        SELECT ( '{' || concat_ws( ', ',
                               '"bd_minr": ' || _tab.bd_minr,
                               '"bd_anf": "' || _tab.bd_anf::varchar || '"',
                               '"bd_end": "' || _tab.bd_end::varchar || '"'
               ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab bdepab ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                              '"bdab_minr": "' || ( SELECT ll_ad_krz FROM llv WHERE ll_minr = _tab.bdab_minr ) || '"',
                              '"bdab_minr": "' || _tab.bdab_minr || '"',
                              '"bdab_anf": "' || _tab.bdab_anf || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab tartikel.beleg_k__artchange ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                              '"k_tablename": "' || _tab.k_tablename || '"',
                                 '"k_kba_key": "' || _tab.k_kba_key || '"',
                                 '"k_code": "' || _tab.k_code || '"',
                                 '"k_nummer": "' || _tab.k_nummer || '"',
                                 '"k_ad_krz": "' || _tab.k_ad_krz || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab tartikel.beleg_p__artchange ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"p_tablename": "' || _tab.p_tablename || '"',
                                 '"p_k_code": "' || _tab.p_k_code || '"',
                                 '"p_k_nummer": "' || _tab.p_k_nummer || '"',
                                 '"p_pos": ' || _tab.p_pos,
                                 '"p_aknr": "' || _tab.p_aknr || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab tartikel.beleg_p__artchange__vorkalk ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"p_tablename": "' || _tab.p_tablename || '"',
                                 '"p_k_code": "' || _tab.p_k_code || '"',
                                 '"p_k_nummer": "' || _tab.p_k_nummer || '"',
                                 '"p_pos": ' || _tab.p_pos,
                                 '"p_aknr": "' || _tab.p_aknr || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab belegabzu ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"beld_belegtyp": "'     || ( SELECT beld_belegtyp     FROM belegdokument WHERE beld_id = _tab.belaz_dokument_id ) || '"',
                                 '"beld_dokunr": "'       || ( SELECT beld_dokunr       FROM belegdokument WHERE beld_id = _tab.belaz_dokument_id ) || '"',
                                 '"beld_krzbesteller": "' || ( SELECT beld_krzbesteller FROM belegdokument WHERE beld_id = _tab.belaz_dokument_id ) || '"',
                                 '"belaz_type": "'        || _tab.belaz_type || '"',
                                 '"belaz_pos": "'         || _tab.belaz_pos || '"',
                                 '"abz_txt": "'           || ( SELECT abz_txt           FROM abzu          WHERE abz_id  = _tab.belaz_abzu_id ) || '"'
              ) ||  '}' ) ::json; 
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab belegdokument ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"beld_belegtyp": "' || _tab.beld_belegtyp || '"',
                                 '"beld_dokunr": "' || _tab.beld_dokunr || '"',
                                 '"beld_krzbesteller": "' || _tab.beld_krzbesteller || '"',
                                 '"beld_erstelldatum": "' || _tab.beld_erstelldatum || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab belegpos ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"beld_belegtyp": "'     || ( SELECT beld_belegtyp     FROM belegdokument WHERE beld_id = _tab.belp_dokument_id ) || '"',
                                 '"beld_dokunr": "'       || ( SELECT beld_dokunr       FROM belegdokument WHERE beld_id = _tab.belp_dokument_id ) || '"',
                                 '"belp_pos": "'          || _tab.belp_pos || '"',
                                 '"beld_krzbesteller": "' || ( SELECT beld_krzbesteller FROM belegdokument WHERE beld_id = _tab.belp_dokument_id ) || '"',
                                 '"belp_aknr": "'         || _tab.belp_aknr || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab belegposabzu ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"beld_belegtyp": "'     || ( SELECT beld_belegtyp     FROM belegdokument WHERE beld_id = ( SELECT belp_dokument_id FROM belegpos WHERE belp_id = _tab.belpaz_belegpos_id ) ) || '"',
                                 '"beld_dokunr": "'       || ( SELECT beld_dokunr       FROM belegdokument WHERE beld_id = ( SELECT belp_dokument_id FROM belegpos WHERE belp_id = _tab.belpaz_belegpos_id ) ) || '"',
                                 '"beld_krzbesteller": "' || ( SELECT beld_krzbesteller FROM belegdokument WHERE beld_id = ( SELECT belp_dokument_id FROM belegpos WHERE belp_id = _tab.belpaz_belegpos_id ) ) || '"',
                                 '"belp_aknr": "'         || ( SELECT belp_aknr         FROM belegpos      WHERE belp_id = _tab.belpaz_belegpos_id ) || '"',
                                 '"abz_txt": "'           || ( SELECT abz_txt           FROM abzu          WHERE abz_id  = _tab.belpaz_abzu_id ) || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab belkopf ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"be_bnr": "' || _tab.be_bnr || '"',
                                 '"be_prof": "' || _tab.be_prof || '"',
                                 '"be_rkrz": "' || _tab.be_rkrz || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab belzeil_auftg_lif ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"bz_be_bnr": "' || _tab.bz_be_bnr || '"',
                                 '"bz_pos": ' || _tab.bz_pos,
                                 '"bz_aknr": "' || _tab.bz_aknr || '"'
              ) ||  '}' ) ::json;   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab belzeil_grund ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"bz_be_bnr": "' || _tab.bz_be_bnr || '"',
                                 '"bz_pos": ' || _tab.bz_pos,
                                 '"bz_aknr": "' || _tab.bz_aknr || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab bestanfpos ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"bap_banr": "' || _tab.bap_banr || '"',
                                 '"bap_pos": ' || _tab.bap_pos
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab bestanftxt ) RETURNS json AS $$
       SELECT ( '{' || '"ba_nr": "' || _tab.ba_nr || '"' ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab bewa ) RETURNS json AS $$
       SELECT ( '{' || '"wa_einh": "' || _tab.wa_einh || '"' ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab eingrechdokument ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"beld_belegtyp": "'     || _tab.beld_belegtyp || '"',
                                 '"beld_dokunr": "'       || _tab.beld_dokunr || '"',
                                 '"beld_krzbesteller": "' || _tab.beld_krzbesteller || '"',
                                 '"beld_krzlieferung": '  || _tab.beld_krzlieferung
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab epreis ) RETURNS json AS $$
       SELECT ( '{' || '"e_lkn": "' || _tab.e_lkn || '"' ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab epreisabzu ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"e_aknr": "'   || ( SELECT e_aknr  FROM epreis WHERE e_id = _tab.eaz_e_id ) || '"',
                                 '"e_lkn": "'    || ( SELECT e_lkn   FROM epreis WHERE e_id = _tab.eaz_e_id ) || '"',
                                 '"eaz_type": "' || _tab.eaz_type || '"',
                                 '"eaz_pos": '   || _tab.eaz_pos,
                                 '"abz_txt": '   || ( SELECT abz_txt FROM abzu   WHERE abz_id  = _tab.eaz_abz_id )
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab epreisstaffel ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"e_aknr": "'   || ( SELECT e_aknr  FROM epreis WHERE e_id = _tab.est_e_id ) || '"',
                                 '"e_lkn": "'    || ( SELECT e_lkn   FROM epreis WHERE e_id = _tab.est_e_id ) || '"'
              ) ||  '}' ) ::json; 
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab eprzutxt ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"ezt_aknr": "' || _tab.ezt_aknr || '"',
                                 '"ezt_lkn": "' || _tab.ezt_lkn || '"',
                                 '"ezt_info": '   || substring( _tab.ezt_info, 1, 50 ) || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab invrech ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"ir_id": "' || _tab.ir_id || '"',
                                 '"ir_an_nr": "' || _tab.ir_an_nr || '"',
                                 '"ir_date": '   || _tab.ir_date
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab karenz ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"kr_tpl_name": "' || _tab.kr_tpl_name || '"',
                                 '"kr_newtime": '   || _tab.kr_newtime,
                                 '"kr_anf": '       || _tab.kr_anf,
                                 '"kr_end": '       || _tab.kr_end
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab ksv ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"ks_abt": "' || _tab.ks_abt || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab ksv_werkzeuge ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"ksw_ks_abt": "' || _tab.ksw_ks_abt || '"',
                                 '"ksw_ak_nr": "'   || _tab.ksw_ak_nr || '"',
                                 '"ksw_txt": "'     || substring( _tab.ksw_txt, 1, 50 ) || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab kundanfrage ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"kanf_nr": "' || _tab.kanf_nr || '"',
                                 '"kanf_ak_nr": "' || _tab.kanf_ak_nr || '"',
                                 '"kanf_ad_krz": "' || _tab.kanf_ad_krz || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab kundanfragepos ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"kanfp_kanf_nr": "' || _tab.kanfp_kanf_nr || '"',
                                 '"kanfp_pos": '      || _tab.kanfp_pos,
                                 '"kanfp_ak_nr": "'   || _tab.kanfp_ak_nr || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab lagartikelkonf ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"lgoa_aknr": "'       || _tab.lgoa_aknr || '"',
                                 '"lgoa_lgo_name": "'   || _tab.lgoa_lgo_name || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab ldsabzu ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"ld_code": "'   || ( SELECT ld_code  FROM ldsdok WHERE ld_id   = _tab.ldaz_ld_id ) || '"',
                                 '"ld_pos": '     || ( SELECT ld_pos   FROM ldsdok WHERE ld_id   = _tab.ldaz_ld_id ),
                                 '"ld_kn": "'     || ( SELECT ld_kn    FROM ldsdok WHERE ld_id   = _tab.ldaz_ld_id ) || '"',
                                 '"ld_aknr": "'   || ( SELECT ld_aknr  FROM ldsdok WHERE ld_id   = _tab.ldaz_ld_id ) || '"',
                                 '"ldaz_type": "' || _tab.ldaz_type || '"',
                                 '"ldaz_pos": "'  || _tab.ldaz_pos || '"',
                                 '"lgoa_aknr": "' || ( SELECT abz_txt  FROM abzu   WHERE abz_id = _tab.ldaz_abz_id ) || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab ldsdok ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"ld_code": "' || _tab.ld_code || '"',
                                 '"ld_auftg": "' || _tab.ld_auftg || '"',
                                 '"ld_pos": ' || _tab.ld_pos,
                                 '"ld_kn": "' || _tab.ld_kn || '"',
                                 '"ld_aknr": "' || _tab.ld_aknr || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab ldsdokdokutxt ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"ltd_dokunr": ' || _tab.ltd_dokunr
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab ldsdoktxt ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"ldt_code": "' || _tab.ldt_code || '"',
                                 '"ldt_auftg": "' || _tab.ldt_auftg || '"',
                                 '"ldt_txt": ' || substring( _tab.ldt_txt, 1, 50 )
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab lifschpack ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"lp_l_dokunr": "'  || _tab.lp_l_dokunr || '"',
                                 '"lp_aknr": "' || _tab.lp_aknr || '"'
              ) ||  '}' ) ::json; 
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab llv ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"ll_minr": '  || _tab.ll_minr,
                                 '"ll_ad_krz": "' || _tab.ll_ad_krz || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab llv_stuko_history ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"ll_ad_krz": "' || ( SELECT ll_ad_krz FROM llv WHERE ll_minr = _tab.llsh_ll_minr ) || '"',
                                 '"llsh_ll_minr": "' || _tab.llsh_ll_minr || '"',
                                 '"llsh_monthyear": "' || _tab.llsh_monthyear || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab mitpln ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"mpl_formonth": ' || _tab.mpl_formonth,
                                 '"mpl_date": "' || _tab.mpl_date || '"',
                                 '"mpl_minr": ' || _tab.mpl_minr,
                                 '"mpl_tpl_name": "' || _tab.mpl_tpl_name || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab ncp_o2_a2_ksv ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                              '"o2_ix": '      || ( SELECT o2_ix    FROM op2 WHERE o2_id = _tab.ncpoak_o2_id ),
                              '"o2_n": '       || ( SELECT o2_n     FROM op2 WHERE o2_id = _tab.ncpoak_o2_id ),
                              '"o2_ks": "'     || ( SELECT o2_ks    FROM op2 WHERE o2_id = _tab.ncpoak_o2_id ) || '"',
                              '"o2_nc": "'     || ( SELECT o2_nc    FROM op2 WHERE o2_id = _tab.ncpoak_o2_id ) || '"',
                              '"ncpoak_ks": "' || _tab.ncpoak_ks || '"',
                              '"ncp_ncnr": "'  || ( SELECT ncp_ncnr FROM ncprogram WHERE ncp_id = _tab.ncpoak_ncp_id ) || '"'
                      ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab ncprogram ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                              '"o2_ix": '      || ( SELECT o2_ix    FROM op2 LEFT JOIN ncp_o2_a2_ksv ON ncpoak_ncp_id = _tab.ncp_id WHERE o2_id = ncpoak_o2_id ),
                              '"o2_n": '       || ( SELECT o2_n     FROM op2 LEFT JOIN ncp_o2_a2_ksv ON ncpoak_ncp_id = _tab.ncp_id WHERE o2_id = ncpoak_o2_id ),
                              '"o2_ks": "'     || ( SELECT o2_ks    FROM op2 LEFT JOIN ncp_o2_a2_ksv ON ncpoak_ncp_id = _tab.ncp_id WHERE o2_id = ncpoak_o2_id ) || '"',
                              '"o2_nc": "'     || ( SELECT o2_nc    FROM op2 LEFT JOIN ncp_o2_a2_ksv ON ncpoak_ncp_id = _tab.ncp_id WHERE o2_id = ncpoak_o2_id ) || '"',
                              '"ncpoak_ks": "' || ( SELECT ncpoak_ks FROM ncp_o2_a2_ksv WHERE ncpoak_ncp_id = _tab.ncp_id ) || '"', 
                              '"ncp_ncnr": "'  || _tab.ncp_ncnr || '"'
                      ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab op2 ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"o2_ix": '   || _tab.o2_ix,
                                 '"op_n": "'   || ( SELECT op_n FROM opl WHERE op_ix = _tab.o2_ix ) || '"',
                                 '"o2_n": '    || _tab.o2_n,
                                 '"o2_txt": "' || substring( _tab.o2_txt, 1, 50 ) || '"'
              ) ||  '}' ) ::json; 
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab op2ba ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"o2ba_ix": '     || _tab.o2ba_ix,
                                 '"op_n": "'       || ( SELECT op_n  FROM opl WHERE op_ix   = _tab.o2ba_ix ) || '"',
                                 '"o2ba_n": '      || _tab.o2ba_n,
                                 '"o2ba_ak_nr": "' || _tab.o2ba_ak_nr || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab op2ksa ) RETURNS json AS $$
      SELECT ( '{' || concat_ws( ', ',
                              '"o2_ix": '     || o2_ix,
                              '"o2_n": '      || o2_n,
                              '"o2_ks": "'    || o2_ks    || '"',
                              '"o2_nc": "'    || o2_nc    || '"',
                              '"o2ks_ks": "'  || o2ks_ks  || '"',
                              '"ncp_ncnr": "' || ncp_ncnr || '"'
                       ) ||  '}' )::json
      FROM op2ksa 
        LEFT JOIN op2 ON o2_id = o2ks_o2_id
        LEFT JOIN ncp_o2_a2_ksv ON ncpoak_o2_id = o2ks_o2_id AND o2ks_ks = ncpoak_ks
      LEFT JOIN ncprogram ON ncpoak_ncp_id = ncp_id 
      WHERE 
      o2ks_o2_id = _tab.o2ks_o2_id AND o2ks_ks = _tab.o2ks_ks;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab op3 ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"o3_ix": '     || _tab.o3_ix,
                                 '"op_n": "'       || ( SELECT op_n FROM opl WHERE op_ix = _tab.o3_ix ) || '"',
                                 '"o3_pos": '      || _tab.o3_pos
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab op5 ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"o2_ix": '       || ( SELECT o2_ix  FROM op2 WHERE o2_ix   = _tab.o5_o2_id ),
                                 '"op_n": "'       || ( SELECT op_n   FROM opl WHERE op_ix   = ( SELECT o2_ix  FROM op2 WHERE o2_id   = _tab.o5_o2_id ) ) || '"',
                                 '"o2_n": '        || ( SELECT o2_n   FROM op2 WHERE o2_ix   = _tab.o5_o2_id ),
                                 '"o5_wz_aknr": "' || _tab.o5_wz_aknr || '"'
              ) ||  '}' ) ::json; 
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab op6 ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"o6_ix": '    || _tab.o6_ix,
                                 '"op_n": "'    || ( SELECT op_n   FROM opl WHERE op_ix   = _tab.o6_ix ) || '"',
                                 '"o6_o2_n": '  || _tab.o6_o2_n,
                                 '"o6_pos": '   || _tab.o6_pos,
                                 '"o6_aknr": "' || _tab.o6_aknr || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab op7 ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"o7_op_ix": ' || _tab.o7_op_ix,
                                 '"op_n": "'    || ( SELECT op_n   FROM opl WHERE op_ix   = _tab.o7_op_ix ) || '"',
                                 '"o7_m": '     || _tab.o7_m,
                                 '"o7_txt": "'  || substr( _tab.o7_txt, 1, 50 ) || '"'
              ) ||  '}' ) ::json; 
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab op7zko ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"o7zk_ix": ' || _tab.o7zk_ix,
                                 '"op_n": "'    || ( SELECT op_n   FROM opl WHERE op_ix   = _tab.o7zk_ix ) || '"',
                                 '"o7zk_krc_bez": "'  || substr( _tab.o7zk_krc_bez, 1, 50 ) || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab op8 ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"o8_ix": '       || _tab.o8_ix,
                                 '"op_n": "'       || ( SELECT op_n   FROM opl WHERE op_ix   = _tab.o8_ix ) || '"',
                                 '"o8_op_stat": "' || _tab.o8_op_stat || '"',
                                 '"o8_pos": "'     || _tab.o8_pos || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab opl ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"op_ix": ' || _tab.op_ix,
                                 '"op_n": "' || _tab.op_n || '"'
              ) ||  '}' ) ::json; 
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab oplpm_data ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                 '"o2_ix": '    || ( SELECT o2_ix FROM op2 WHERE o2_id = _tab.pm_op2_id ),
                                 '"o2_n": "'    || ( SELECT o2_n  FROM op2 WHERE o2_id = _tab.pm_op2_id ) || '"',
                                 '"pm_pmnr": '  || _tab.pm_pmnr,
                                 '"pm_nenn": "' || _tab.pm_nenn || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab oplpm_mw ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                  '"ab_ix": '        || ( SELECT a2_ab_ix FROM ab2        WHERE a2_id = _tab.mw_pm_id ),
                                  '"a2_n": "'        || ( SELECT a2_n     FROM ab2        WHERE a2_id = _tab.mw_pm_id ) || '"',
                                  '"pm_pmnr": "'     || ( SELECT pm_pmnr  FROM oplpm_data WHERE pm_id = _tab.mw_pm_id ) || '"',
                                  '"mw_pr_pmnr": "'  || _tab.mw_pr_pmnr || '"',
                                  '"mw_pruefer": "'  || _tab.mw_pruefer || '"'/*,
                                  '"mw_pruefzeit": ' || _tab.mw_pruefzeit*/
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab personal ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                  '"pers_krz": "'  || _tab.pers_krz || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab qab ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                  '"q_nr": "'    || _tab.q_nr || '"',
                                  '"q_typ": "'   || _tab.q_typ || '"',
                                  '"q_ak_nr": "' || _tab.q_ak_nr || '"',
                                  '"q_krzl": "'  || _tab.q_krzl || '"'
              ) ||  '}' ) ::json; 
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab qabteam ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                  '"qteam_qnr": "'  || _tab.qteam_qnr || '"',
                                  '"qteam_minr": "'  || _tab.qteam_minr || '"'
              ) ||  '}' ) ::json;   
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab recnogroup ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                  '"reg_tablename": "'  || _tab.reg_tablename || '"',
                                  '"reg_pname": "'      || _tab.reg_pname || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab recnokeyword ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                  '"r_dbrid": "'     || _tab.r_dbrid || '"',
                                  '"r_tablename": "' || _tab.r_tablename || '"',
                                  '"r_reg_pname": "' || _tab.r_reg_pname || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab settings ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                  '"s_vari": "' || coalesce( _tab.s_vari, ( SELECT sd_name FROM SettingsDyn WHERE _tab.s_vari = sd_settingsname ), '***'  ) || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab softlink ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                               concat_ws( ': ', '"slink_bez"', _tab.slink_bez ),
                               concat_ws( ' = ', GetFieldAlias( 'slink_table' )  , _tab.slink_table ),
                               concat_ws( ': ', '"slink_type"'    , _tab.slink_type )
                      ) ||  '}' )::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab stundauszahl ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                  '"sa_id": "'     || _tab.sa_id || '"',
                                  '"ll_ad_krz": "' || ( SELECT ll_ad_krz FROM llv WHERE ll_minr = _tab.sa_minr ) || '"',
                                  '"sa_minr": "'   || _tab.sa_minr || '"',
                                  '"sa_date": "'   || _tab.sa_date || '"'
              ) ||  '}' ) ::json; 
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab stv ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                  '"st_n": "'  || _tab.st_n || '"',
                                  '"st_pos": ' || _tab.st_pos
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab stv_op2 ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                  '"st_n": "'  || ( SELECT st_n   FROM stv WHERE st_id = _tab.sto2_st_id ) || '"',
                                  '"st_pos": ' || ( SELECT st_pos FROM stv WHERE st_id = _tab.sto2_st_id ),
                                  '"o2_ix": '  || ( SELECT o2_ix  FROM op2 WHERE o2_id = _tab.sto2_o2_id ),
                                  '"o2_n": '   || ( SELECT o2_n   FROM op2 WHERE o2_id = _tab.sto2_o2_id )
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab stvrevision ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                  '"str_revnr": "' || _tab.str_revnr || '"',
                                  '"str_resid": '  || _tab.str_resid,
                                  '"str_txt": '    || substr(_tab.str_txt, 1, 50)
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab stvzutxt ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                  '"stv_zn": "'   || _tab.stv_zn || '"',
                                  '"stv_txt": "'  || substr( _tab.stv_txt, 1, 50 ) || '"',
                                  '"stv_stat": "' || _tab.stv_stat || '"'
              ) ||  '}' ) ::json; 
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab tplan ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                  '"tpl_name": "'   || _tab.tpl_name || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab tplanblock ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                  '"tplbl_tpl_name": "' || _tab.tplbl_tpl_name || '"',
                                  '"tplbl_begin": "'    || _tab.tplbl_begin || '"',
                                  '"tplbl_end": "'      || _tab.tplbl_end || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab tplanpause ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                  '"tplp_tpl_name": "' || _tab.tplp_tpl_name || '"',
                                  '"tplp_begin": "'    || _tab.tplp_begin || '"',
                                  '"tplp_end": "'      || _tab.tplp_end || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
CREATE OR REPLACE FUNCTION tlog.Auditlog__table__ident_json( IN _tab werkzeug ) RETURNS json AS $$
       SELECT ( '{' || concat_ws( ', ',
                                  '"wz_id": "'   || _tab.wz_id || '"',
                                  '"wz_aknr": "' || _tab.wz_aknr || '"',
                                  '"wz_wznr": "' || _tab.wz_wznr || '"',
                                  '"wz_hest": "' || _tab.wz_hest || '"'
              ) ||  '}' ) ::json;
  $$ LANGUAGE sql STABLE PARALLEL SAFE;
---
